IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[usp_Filter_Movements_Without_Bed]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[usp_Filter_Movements_Without_Bed]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author		:	roxanas
-- Created date	:	01/15/2013
-- Description	:	Gets admissions and movements without bed.
-- =============================================
CREATE PROCEDURE [dbo].[usp_Filter_Movements_Without_Bed] 
	@START_DATE DATETIME,
	@END_DATE DATETIME,
	@VISTA_SITE_UID UNIQUEIDENTIFIER
AS
BEGIN
	SET NOCOUNT ON;

	SELECT ID, IEN, WARD_UID, BED_UID
	FROM
		(SELECT ID, IEN, INITIAL_WARD_UID AS WARD_UID, INITIAL_BED_UID AS BED_UID
		FROM ADMISSION_EVN
			WHERE VISTA_SITE_UID = @VISTA_SITE_UID AND ADMISSION_DATE BETWEEN @START_DATE AND @END_DATE AND INITIAL_BED_UID IS NULL
		UNION ALL
		SELECT ID, IEN, WARD_UID, BED_UID
		FROM MOVEMENT_EVN
			WHERE VISTA_SITE_UID = @VISTA_SITE_UID AND MOVEMENT_DATE BETWEEN @START_DATE AND @END_DATE AND BED_UID IS NULL) A 
	ORDER BY CAST(IEN AS BIGINT)
	
END
GO